<?php

return [
    '_meta' => [
        'type' => 'newsletters',
        'fieldsPrefix' => ''
    ],
    'logo' => [
        'showLogo'  => true,
        'logoUrl'   => 'vendor/maecia/fare-back/resources/assets/img/newsletter/logo.png',
        'logoWidth' => 200
    ],
    'banner'       => [
        'backgroundImageUrl' => 'vendor/maecia/fare-back/resources/assets/img/newsletter/bg.jpg',
        'backgroundColor' => '#ffff'
    ],
    'introduction' => [
        'introductionFieldName' => 'newsletter_introduction',
        'textColor' => '#2C3E50'
    ],
    'sections'     => [
        'news'       => [
            'sectionTitleStrKey' => 'newsletter.news_title',
            'types' => ['news'],
            'dateFormat' => '%d/%m/%Y',
            'showCategoryTitle' => true,
            'defaultCategoryColor' => '#790724',
            'link' => [
                'sectionLinkUrl'  => 'actualites',
                'sectionTextColor' => '#2C3E50',
            ],
        ],
        'events'     => [
            'sectionTitleStrKey' => 'newsletter.events_title',
            'types' => ['events'],
            'sorts' => ['date:desc'],
            'dateFormat' => '%d/%m/%Y',
            'link' => [
                'sectionLinkUrl'   => 'events',
                'sectionTextColor' => '#2C3E50',
            ],
        ],
        'documents'  => [
            'sectionTitleStrKey' => 'newsletter.documents_title',
            'types'           => ['documents'],
            'sorts' => ['created_at:desc'],
            'imageStyle' => 'medium',
            'dateFormat' => '%d/%m/%Y',
            'link'            => [
                'sectionLinkStrKey' => 'newsletter.see_all_documents',
                'sectionLinkUrl' => 'bibliotheque',
                'sectionTextColor' => '#2C3E50'
            ],
        ],
    ],
    'footer'       => [
        'backgroundColor' => '#ffffff',
        'unsubscribeTextColor' => '#818181',
        'unsubscribeTextStrKey' => 'newsletter.unsubscribe.warning'
    ],
];
