<?php

namespace Inside\FARE\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Storage;
use Inside\Content\Models\Contents\Tools;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class QuickAccessSeeder extends Seeder
{
    public function run(): void
    {
        $bridgeContent = new BridgeContent();
        $bridgeContentType = new BridgeContentType();

        $orderedTools = [
            'Procédures groupe' => 0,
            'SharePoint FAREVA' => 1,
            'Cybersécurité E-learning' => 2
        ];

        $tools = Tools::query()
            ->whereIn('title', array_keys($orderedTools))
            ->where('status', 1)
            ->where('langcode', 'fr')
            ->get()
            ->sortBy(fn (Tools $tool) => $orderedTools[$tool->title]);

        $defaultToolsUuids = $tools->map(
            fn ($tool) => ['target_uuid' => $tool->uuid_host]
        )->toArray();

        // update default tools field in users config
        $bridgeContentType->contentTypeCreateOrUpdateField(
            type: 'users',
            fieldName: 'tools',
            options: [
                'title' => [
                    'fr' => 'Accès rapide',
                    'en' => 'Quick access'
                ],
                'default' => $defaultToolsUuids
            ]
        );


        // Update all users with default tools
        Users::all()->each(fn ($user) => $bridgeContent->updateReferenceFields(
            type: 'users',
            contentUuidHost: $user->uuid_host,
            data: [
                'tools' => $defaultToolsUuids
            ]
        ));
    }
}
