<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;

class DisableCategorizableContents extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeUpdateOrCreate('locations', [
            'name' => 'locations',
            'permissible' => true,
            'categorizable' => false,
        ]);

        $bridge->contentTypeUpdateOrCreate('entities', [
            'name' => 'entities',
            'permissible' => true,
            'categorizable' => false,
        ]);

        $bridge->contentTypeUpdateOrCreate('services', [
            'name' => 'services',
            'permissible' => true,
            'categorizable' => false,
        ]);

        $bridge->contentTypeUpdateOrCreate('pages_categories', [
            'name' => 'pages_categories',
            'permissible' => true,
            'categorizable' => false,
        ]);

        $bridge->contentTypeUpdateOrCreate('pages', [
            'name' => 'pages',
            'permissible' => true,
            'categorizable' => false,
        ]);

        Artisan::call("models:rebuild");
    }
}
