<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

final class AddCitiesContentType extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();
        $bridge->contentTypeUpdateOrCreate(
            type: 'cities',
            options: [
                'name' => 'cities',
                'translatable' => true,
                'searchable' => true,
                'global_searchable' => false,
                'aliasable' => false,
                'permissible' => true,
                'categorizable' => true,
                'listing_type' => 'content',
                'title' => [
                    'en' => 'City',
                    'fr' => 'Ville',
                ],
            ],
            fields: [
                [
                    'name' => 'code',
                    'searchable' => false,
                    'translatable' => true,
                    'search_result_field' => false,
                    'searchable_filter' => false,
                    'required' => false,
                    'weight' => 0,
                    'title' => [
                        'fr' => 'code',
                        'en' => 'code',
                    ],
                    'widget' => [
                        'hidden' => true,
                    ],
                    'type' => BridgeContentType::TEXT_FIELD,
                    'settings' => [
                        'max_length' => 255,
                        'is_ascii' => false,
                        'case_sensitive' => false,
                        'cardinality' => 1,
                    ],
                ]
            ]
        );

        $bridge->contentTypeCreateOrUpdateField('users', 'cities', [
            'name' => 'cities',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => true,
            'required' => false,
            'weight' => 5,
            'title' => [
                'en' => 'City',
                'fr' => 'Ville',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 5,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['cities'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ], 5);

        Artisan::call('models:rebuild');
    }
}
