<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Tools;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class SeedDefaultTools extends Migration
{
    public function up(): void
    {
        $tools = [
            'E-Temptation - Horoquartz',
            'GLPI',
            'Digiposte'
        ];

        $bridgeContent = new BridgeContent();
        $bridge = new BridgeContentType();
        $tools = collect($tools)->map(fn (string $title) => $this->getToolUuids($bridgeContent, $title));

        $bridge->contentTypeCreateOrUpdateField('users', 'tools', [
            'default' => $tools->pluck('uuid_host')->map(fn (string $uuid_host) => ['target_uuid' => $uuid_host])->all(),
        ]);

        Users::each(function (Users $user) use ($bridgeContent, $tools) {
            $defaultTools = $tools->pluck($user->langcode);

            $bridgeContent->contentUpdate('users', [
                'uuid' => $user->uuid,
                'tools' => $defaultTools->all(),
            ]);
        });
    }

    private function getToolUuids(BridgeContent $bridge, string $title): array
    {
        $locale = config('app.locale');
        $languages = collect(list_languages())->diff([$locale]);

        $original = Tools::where(['title' => $title, 'langcode' => $locale])->first();

        if (!$original instanceof Tools) {
            $original = $bridge->contentInsert('tools', ['title' => $title, 'langcode' => $locale]);
            $original = Tools::findOrFail($original);
        }

        // collection of type [langcode => uuid]
        $uuids = $languages->mapWithKeys(function (string $langcode) use ($bridge, $title, $original) {
            $data = [
                'title' => $title,
                'langcode' => $langcode,
                'uuid_host' => $original->uuid_host,
            ];

            $uuid = Tools::where($data)->first()?->uuid ?? $bridge->contentInsert('tools', $data);
            return [$langcode => $uuid];
        });

        return $uuids->merge([$locale => $original->uuid, 'uuid_host' => $original->uuid_host])->all();
    }
}
