
<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class AddSitesToSpaces extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            type: 'spaces',
            fieldName: 'sites',
            options: [
                'name' => 'sites',
                'searchable' => true,
                'translatable' => true,
                'search_result_field' => true,
                'searchable_filter' => true,
                'required' => true,
                'weight' => 6,
                'title' => [
                    'fr' => 'Sites',
                    'en' => 'Sites',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 6,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['sites'],
                    'cardinality' => -1,
                ],
                'selectable_all' => true,
            ],
            weight: 6
        );
    }
}
