<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddIsFeaturedFieldToBlocks extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            type: 'blocks',
            fieldName: 'is_featured',
            options: [
                'name' => 'is_featured',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 8,
                'title' => [
                    'fr' => 'Mettre en avant ?',
                    'en' => 'Featured?',
                ],
                'description' => [
                    'fr' => 'Permet d\'afficher ce bloc en haut de la page d\'accueil (Limité à 3)',
                    'en' => 'Displays this block at the top of the home page (Limited to 3)',
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'settings' => [
                        'display_label' => true,
                    ],
                    'weight' => 8,
                ],
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
                'default' => false,
            ],
            weight: 8
        );
    }
}
