<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Migrations\CreateContentTypes;

class AddSitesToNews extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('sites');
        $this->finishUp();

        Artisan::call('models:rebuild');

        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            type: 'news',
            fieldName: 'sites',
            options: [
                'name' => 'sites',
                'searchable' => true,
                'translatable' => true,
                'search_result_field' => true,
                'searchable_filter' => true,
                'required' => true,
                'weight' => 6,
                'title' => [
                    'fr' => 'Sites',
                    'en' => 'Sites',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 6,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['sites'],
                    'cardinality' => -1,
                ],
                'selectable_all' => true,
            ],
            weight: 6
        );
    }
}
