<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class OverwriteFlashContentType extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        if (! Schema::hasTable('node__field_background_color')) {
            DB::statement('CREATE TABLE `node__field_background_color` (
                `bundle` varchar(128) CHARACTER SET ascii NOT NULL DEFAULT \'\' COMMENT \'The field instance bundle to which this row belongs, used when deleting a field instance\',
                `deleted` tinyint(4) NOT NULL DEFAULT 0 COMMENT \'A boolean indicating whether this data item has been deleted\',
                `entity_id` int(10) unsigned NOT NULL COMMENT \'The entity id this data is attached to\',
                `revision_id` int(10) unsigned NOT NULL COMMENT \'The entity revision id this data is attached to\',
                `langcode` varchar(32) CHARACTER SET ascii NOT NULL DEFAULT \'\' COMMENT \'The language code for this data item.\',
                `delta` int(10) unsigned NOT NULL COMMENT \'The sequence number for this data item, used for multi-value fields\',
                `field_background_color_value` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
                PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),
                KEY `bundle` (`bundle`),
                KEY `revision_id` (`revision_id`)
                ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT=\'Data storage for node field field_background_color.\';
            ');
        }

        $this->bootUp(__FILE__);
        $this->migrateContent('blocks', false);
        $this->migrateContent('flash_news', false);
        $this->finishUp();
    }
}
