<?php

use Illuminate\Support\Collection;
use Inside\User\Models\User;

return [
    'postfilter' => function (Collection $users) {
        return $users->filter(fn ($user) => $user->accountEnabled);
    },
    'sync_attributes' => [
        'email' => 'mail',
        'name' => 'mail',
        'lastname' => 'surname',
        'firstname' => 'givenName',
        'function' => 'jobTitle',
        'image' => fn (mixed $user) => avatar($user->photo, User::query()->where('email', $user->mail)->first()),
        'cities' => fn (mixed $user) => reference('cities')->identifiedBy('code')->from($user->city)->get(),
        'services' => fn (mixed $user) => reference('services')->identifiedBy('code')->from($user->department)->get(),
        'locations' => fn (mixed $user) => reference('locations')->identifiedBy('code')->from($user->onPremisesExtensionAttributes->extensionAttribute7)->get(),
        'entities' => fn (mixed $user) => reference('entities')->identifiedBy('code')->from($user->officeLocation)->get(),
        'manager' => fn (mixed $user) => reference('users')->identifiedBy('email')->from($user->manager)->withoutCreation()->get(),
        'is_maintenance' => fn () => false,
        'phone' => fn (mixed $user) => match (true) {
            !blank($user->mobilePhone) => $user->mobilePhone,
            !blank($user->businessPhones) => $user->businessPhones[0],
            default => null,
        },
        'switchboard_phone' => fn (mixed $user) => $user->extension_fbf391ffe06242da8782de90464a0415_telephoneAssistant,
    ],
    'custom_attributes' => [
        'manager' => 'mail',
    ],
];
