<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;

class FareCategorizableForms extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeUpdateOrCreate('forms', [
            'name' => 'forms',
            'permissible' => true,
            'categorizable' => true,
        ]);

        $bridge->contentTypeUpdateOrCreate('cards_links', [
            'name' => 'cards_links',
            'permissible' => true,
            'categorizable' => true,
        ]);

        $bridge->contentTypeUpdateOrCreate('blocks', [
            'name' => 'blocks',
            'permissible' => true,
            'categorizable' => true,
        ]);

        Artisan::call("models:rebuild");
    }
}
