<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Database\Eloquent\Builder;
use Inside\Host\Bridge\BridgeContent;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Models\Contents\Custom;

class AddCustomPageQuizzListing extends Migration
{
    public function up(): void
    {
        Artisan::call('models:rebuild');
        $bridge = new BridgeContent();


        $customDataFr = [
            'title' => 'Liste des quiz',
            'custom_slug' => 'quiz',
            'redirection_page' => 'QuizListingPage',
            'status' => 1,
            'langcode' => 'fr',
        ];

        $existingFr = Custom::query()
            ->where('custom_slug', $customDataFr['custom_slug'])
            ->where('redirection_page', $customDataFr['redirection_page'])
            ->where('langcode', 'fr')
            ->first();

        if ($existingFr instanceof Custom) {
            $customDataFr['uuid'] = $existingFr->uuid;
        }

        $originalUuid = $bridge->contentInsert(
            type: 'custom',
            data: $customDataFr,
            creation: !isset($customDataFr['uuid']),
            fromCli: true
        );

        $original = Custom::query()->where('uuid', $originalUuid)->first();

        $customDataEn = [
            'title' => 'Quiz Listing Page',
            'custom_slug' => 'quiz',
            'redirection_page' => 'QuizListingPage',
            'langcode' => 'en',
            'uuid_host' => $original->uuid_host,
        ];

        $existingEn = Custom::query()
            ->where('custom_slug', $customDataEn['custom_slug'])
            ->where('redirection_page', $customDataEn['redirection_page'])
            ->where('uuid_host', $customDataEn['uuid_host'])
            ->where('langcode', 'en')
            ->first();

        if ($existingEn instanceof Custom) {
            $customDataEn['uuid'] = $existingEn->uuid;
        }

        $bridge->contentInsert(
            type: 'custom',
            data: $customDataEn,
            creation: !isset($customDataEn['uuid']),
            fromCli: true
        );
    }
}
