<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Bridge\BridgeContent;
use Inside\Content\Models\Contents\Locations;

class MakeUsersFieldsTranslatable extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();
        $bridgeContent = new BridgeContent();
        try {
            $bridge->updateContentTypeOptions(
                type: 'locations',
                options: [
                    'translatable' => true
                ]
            );

            $frLocationsUuidHosts = Locations::where([
                'status' => 1,
                'langcode' => 'fr'
            ])->get()->pluck('uuid_host');

            Locations::where([
                'langcode' => 'en'
            ])->whereIn('uuid_host', $frLocationsUuidHosts)
                ->get()
                ->each(function ($location) use ($bridgeContent) {
                    try {
                        $bridgeContent->contentUpdate(
                            type: 'locations',
                            data: [
                            'title' => $location->title,
                            'uuid' => $location->uuid,
                            'status' => 1
                        ]
                        );
                    } catch (\Exception $exception) {
                    }
                });

            Artisan::call('models:rebuild');
        } catch (Exception $e) {
            return;
        }
    }
}
