<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class ActiveDirectory extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->changeFieldTitle('users', 'entities', ['fr' => "Localisation", 'en' => "Location"]);

        $bridge->contentTypeCreateOrUpdateField(
            'users',
            'manager',
            [
                'name' => 'manager',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 10,
                'title' => [
                    'fr' => 'Manager',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 10,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => 'users',
                    'cardinality' => -1,
                ],
                'selectable_all' => true,
            ]
        );
    }
}
