<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddCodeFieldToUserReferenceContentTypes extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        collect(['entities', 'services', 'locations'])->each(fn ($contentType) => $bridge->contentTypeCreateOrUpdateField(
            $contentType,
            'code',
            [
                'name' => 'code',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 1,
                'title' => [
                    'fr' => 'Référence d\'import',
                    'en' => 'Import reference',
                ],
                'widget' => [
                    'hidden' => true,
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ]
        ));
    }

    public function down(): void
    {
    }
}
