<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Tools;
use Inside\Host\Migrations\CreateContentTypes;

final class SeedDefaultTools extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $defaultToolsTitles = [
            'Sharepoint',
            'Google',
            "Livret d'accueil",
            'GLPI',
            'Agenda',
        ];

        $defaultTools = Tools::query()
            ->where('langcode', config('app.locale'))
            ->whereIn('title', $defaultToolsTitles)
            ->get()
            ->sortBy(fn (Tools $tool) => array_search($tool->title, $defaultToolsTitles));

        $this->getBridge()?->contentTypeUpdateField('users', 'tools', [
            'default' => $defaultTools->pluck('uuid_host')->map(fn (string $uuid_host) => ['target_uuid' => $uuid_host])->all(),
        ]);

        $this->finishUp();
    }
}
