import { http } from '@inside-library/helpers/Http'

export default {
  entityNavigationPage: {
    add: async ({ data }) => {
      const { data: page } = await http.get('content/entity_navigation_page', {
        fields: ['uuid', 'title', 'slug'],
        filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
      })

      return {
        name: 'EntityPage',
        params: {
          slug: page[0].slug[0]
        }
      }
    },
    delete: async ({ uuid }) => {
      const { data: tabs } = await http.get('content/tabs', {
        fields: ['uuid', { spaces: ['uuid', 'title', 'slug'] }],
        filters: { 'status:eq': 1, 'uuid:eq': uuid }
      })

      return {
        name: 'SpacePage',
        params: {
          slug: tabs?.[0].spaces?.slug?.[0]
        }
      }
    }
  },
  navigationCard: {
    add: async ({ data }) => {
      const { data: page } = await http.get('content/navigation_card', {
        fields: ['uuid', { entity_navigation_page: ['uuid', 'slug'] }],
        filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
      })

      return {
        name: 'EntityPage',
        params: {
          slug: page[0].entity_navigation_page.data[0].slug[0]
        }
      }
    },
    delete: async ({ uuid }) => {
      const { data: page } = await http.get('content/navigation_card', {
        fields: ['uuid', { entity_navigation_page: ['uuid', 'slug'] }],
        filters: { 'status:eq': 1, 'uuid:eq': uuid }
      })

      return {
        name: 'EntityPage',
        params: {
          slug: page[0].entity_navigation_page.data[0].slug[0]
        }
      }
    }
  },
  fullPageBlock: {
    add: async ({ data }) => {
      const { data: page } = await http.get('content/full_page_block', {
        fields: ['uuid', { entity_navigation_page: ['uuid', 'slug'] }],
        filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
      })

      return {
        name: 'EntityPage',
        params: {
          slug: page[0].entity_navigation_page.data[0].slug[0]
        }
      }
    },
    delete: async ({ uuid }) => {
      const { data: page } = await http.get('content/full_page_block', {
        fields: ['uuid', { entity_navigation_page: ['uuid', 'slug'] }],
        filters: { 'status:eq': 1, 'uuid:eq': uuid }
      })

      return {
        name: 'EntityPage',
        params: {
          slug: page[0].entity_navigation_page.data[0].slug[0]
        }
      }
    }
  }
}
