import { http } from '@inside-library/helpers/Http'

const fetchEntity = async ({ $route }) => {
  try {
    const { data } = await http.get('content/entity_navigation_page', {
      fields: [
        'uuid',
        'title',
        'banner',
        'introduction',
        'content_type',
        'admin'
      ],
      filters: { 'status:eq': 1, 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export { fetchEntity }
