import imageHomeEntities from '../../assets/img/custom-page/imageHomeEntities.png'

export const availableComponents = t => [
  {
    component: 'HomeEntities',
    label: t('customs.CUSTOM_PAGE.homeEntities.label'),
    image: imageHomeEntities,
    options: {
      pagination: { value: false },
      blockOptions: {
        title: {
          type: 'text',
          value: t('customs.CUSTOM_PAGE.homeEntities.options.title.value'),
          title: t('customs.CUSTOM_PAGE.homeEntities.options.title.title')
        },
        titleOptions: {
          type: 'radio',
          value: { alignment: 'center' },
          title: t(
            'customs.CUSTOM_PAGE.homeEntities.options.titleOptions.title'
          ),
          options: [
            {
              label: t(
                'customs.CUSTOM_PAGE.homeEntities.options.titleOptions.left'
              ),
              value: { alignment: 'left' }
            },
            {
              label: t(
                'customs.CUSTOM_PAGE.homeEntities.options.titleOptions.center'
              ),
              value: { alignment: 'center' }
            },
            {
              label: t(
                'customs.CUSTOM_PAGE.homeEntities.options.titleOptions.right'
              ),
              value: { alignment: 'right' }
            }
          ],
          rules: ['required']
        },
        titleTag: {
          type: 'selectbox',
          value: 'h2',
          title: t('customs.CUSTOM_PAGE.homeEntities.options.titleTag.title'),
          inputData: [
            {
              label: t('customs.CUSTOM_PAGE.homeEntities.options.titleTag.h1'),
              value: 'h1'
            },
            {
              label: t('customs.CUSTOM_PAGE.homeEntities.options.titleTag.h2'),
              value: 'h2'
            },
            {
              label: t('customs.CUSTOM_PAGE.homeEntities.options.titleTag.h3'),
              value: 'h3'
            },
            {
              label: t('customs.CUSTOM_PAGE.homeEntities.options.titleTag.h4'),
              value: 'h4'
            },
            {
              label: t('customs.CUSTOM_PAGE.homeEntities.options.titleTag.h5'),
              value: 'h5'
            }
          ],
          multiple: false
        }
      },
      itemsPerPage: {
        type: 'number',
        value: 24,
        title: t('customs.CUSTOM_PAGE.homeEntities.options.itemsPerPage.title'),
        rules: ['required']
      }
    },
    layouts: [{ layout: 1 }]
  }
]

export const componentImport = {
  HomeEntities: () => import('../../components/homepage/HomeEntities')
}
