import EntityPage from '../pages/entities/EntityPage'
import TabsSpacePage from '../pages/spaces/TabsSpacePage'
import { fetchEntity } from '../fetch'
import { fetchTabSpacesPage } from '@inside-layouts/fetch'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    meta: { disabled: false, isCustomPage: true }
  },
  {
    name: 'DirectoryPage',
    component: () => import('../pages/directory/DirectoryPage'),
    meta: { disabled: false }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false,
      extraFilters: {
        sort: 'weight:asc'
      }
    }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'TabsSpacePage',
    component: withFetch(TabsSpacePage, { size: 'xxl', watch: true })(
      fetchTabSpacesPage
    ),
    meta: { disabled: false, content: 'tabs_spaces' }
  },
  {
    name: 'FormPage',
    meta: { disabled: true }
  },
  {
    name: 'EntityPage',
    path: {
      fr: '/entite/:slug',
      en: '/entity/:slug',
      es: '/entidad/:slug'
    },
    component: withFetch(EntityPage, { size: 'xxl', watch: true })(fetchEntity),
    meta: { content: 'entity_navigation_page' }
  },
  {
    name: 'NewsCategoriesListingPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsCategoriesPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'AdminAdvancedSettingsAutomaticTranslationPage',
    meta: { admin: true, display: true }
  },
  {
    name: 'AdminAdvancedSettingsWeatherPage',
    meta: { admin: true, display: true }
  },
  {
    name: 'AdminAdvancedSettingsSsoConnectionPage',
    meta: { admin: true, display: true }
  }
]
