<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class EditFullPageBlockFields extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField(
            entityType: 'node',
            type: 'full_page_block',
            fieldName: 'tabs_spaces'
        );

        $bridge->contentTypeCreateOrUpdateField(
            type: 'full_page_block',
            fieldName: 'news_categories_listings',
            options:  [
                'name' => 'news_categories_listings',
                'translatable' => true,
                'searchable' => true,
                'global_searchable' => false,
                'aliasable' => true,
                'permissible' => true,
                'categorizable' => true,
                'listing_type' => 'taxo',
                'title' => [
                    'fr' => 'Listing catégorie d\'actualités',
                    'en' => 'News categories listing',
                    'es' => 'Listado de categorías de noticias',
                    'pt' => 'Listagem de categorias de notícias',
                    'de' => 'Nachrichtenkategorienliste',
                    'nl' => 'Lijst van nieuwscategorieën',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 3,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['news_categories_listings'],
                    'cardinality' => 1,
                ],
            ]
        );
    }
}
