<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema as InsideSchema;

class UpdateTranslateContentTypes extends Migration
{
    public function up(): void
    {
        $types = [
            'connexion_popups' => [
                "nl" => "Inlogvenster",
                "de" => "Login-Popup",
                "es" => "Ventana emergente de inicio de sesión",
                "fr" => "Popin de connexion",
                "en" => "Login popup",
                "pt" => "Janela de login",
            ],
            'public_pages' => [
                "nl" => "Openbare pagina",
                "de" => "Öffentliche Seite",
                "es" => "Pagina publica",
                "fr" => "Page publique",
                "en" => "Public page",
                "pt" => "Página pública",
            ],
            'pages' => [
                "nl" => "Enkele pagina",
                "de" => "Einzelne Seite",
                "es" => "Una sola página",
                "fr" => "Page simple",
                "en" => "Single page",
                "pt" => "Página única",
            ],
            'tabs_pages' => [
                'fr' => 'Sous Page Onglet',
                'en' => 'Sub Page Tab',
                'nl' => 'Tabblad Subpagina',
                'pt' => 'Guia Subpágina',
                'es' => 'Pestaña de subpágina',
                'de' => 'Registerkarte „Unterseite“.',
            ],
            'news_categories' => [
                'fr' => 'Catégorie d\'actualité',
                'en' => 'News Category',
                'nl' => 'Nieuwscategorie',
                'pt' => 'Categoria de notícias',
                'es' => 'Categoría de noticias',
                'de' => 'Nachrichten-Kategorie',
            ],
            'tabs_spaces' => [
                'fr' => 'Espace à onglets',
                'en' => 'Tab spaces',
                'nl' => 'Tabbladen',
                'pt' => 'Espaços de tabulação',
                'es' => 'Espacios de tabulación',
                'de' => 'Tabulator-Leerzeichen',
            ]
        ];
        $fields = [
            'full_page_block' => [
                'image' => [
                    'fr' => 'Image',
                    'en' => 'Image',
                    'es' => 'Imagen',
                ],
                'entity_navigation_page' => [
                    'fr' => 'Entité',
                    'en' => 'Entity',
                    'es' => 'Entidad',
                ],
                'tabs_spaces' => [
                    'fr' => 'Espace à onglets',
                    'en' => 'Tabbed space',
                    'es' => 'espacio de tabulación',
                    ]
            ],
            'navigation_card' => [
                'image' => [
                    'fr' => 'Image',
                    'en' => 'Image',
                    'es' => 'Imagen',
                ],

                'entity_navigation_page' => [
                    'fr' => 'Entité',
                    'en' => 'Entity',
                    'es' => 'Entidad',
                ],
                'tabs_spaces' => [
                    'fr' => 'Espace à onglets',
                    'en' => 'Tabbed space',
                    'es' => 'Espacio de tabulación',
                ],
                'weight' => [
                    'fr' => 'Ordre d\'affichage',
                    'en' => 'Display order',
                    'es' => 'Orden de visualización',
                ]
            ],
            'news_categories' => [
                'color' => [
                    'fr' => 'Couleur',
                    'en' => 'Color',
                    'nl' => 'Kleur',
                    'pt' => 'Cor',
                    'es' => 'Color',
                    'de' => 'Farbe',
                ],
                'news_categories_listings' => [
                    'fr' => 'Listing catégorie d\'actualités',
                    'en' => 'News categories listing',
                    'es' => 'Listado de categorías de noticias',
                    'pt' => 'Listagem de categorias de notícias',
                    'de' => 'Nachrichtenkategorienliste',
                    'nl' => 'Lijst van nieuwscategorieën',
                ]
            ],
            'tools_categories' => [
                'weight' => [
                    'fr' => 'Ordre d\'affichage',
                    'en' => 'Order of appearance',
                    'nl' => 'Weergavevolgorde',
                    'pt' => 'Ordem de exibição',
                    'es' => 'orden de aparición',
                    'de' => 'Reihenfolge des Erscheinens',
                ],
                'tools_categories_listings' => [
                    'fr' => 'Listing d\'outils',
                    'en' => 'Tool List',
                    'nl' => 'Gereedschapslijst',
                    'pt' => 'Lista de ferramentas',
                    'es' => 'Lista de herramientas',
                    'de' => 'Werkzeugliste',
                ],
            ],
            'popins' => [
                'content' => [
                    'fr' => 'Consentement utilisateur',
                    'en' => 'User Consent',
                    'es' => 'Consentimiento del usuario',
                    'de' => 'Nutzerzustimmung',
                    'pt' => 'Consentimento do usuário',
                    'nl' => 'Toestemming van de gebruiker',
                ],
            ],
            'documents' => [
                'image' => [
                    'fr' => 'Image de prévisualisation',
                    'en' => 'Preview Image',
                    'nl' => 'Voorbeeldafbeelding',
                    'pt' => 'Pré-visualizar imagem',
                    'es' => 'Imagen de vista previa',
                    'de' => 'Vorschaubild',
                ],
                'file' => [
                    'fr' => 'Fichier',
                    'en' => 'File',
                    'nl' => 'Bestand',
                    'pt' => 'Ficheiro',
                    'es' => 'Expediente',
                    'de' => 'Datei',
                ],
                'content' => [
                    'fr' => 'Contenu',
                    'en' => 'Content',
                    'nl' => 'Inhoud',
                    'pt' => 'Conteúdo',
                    'es' => 'Contenido',
                    'de' => 'Inhalt',
                ],
                'folders' => [
                    'fr' => 'Dossier parent',
                    'en' => 'Parent folder',
                    'nl' => 'Bovenliggende map',
                    'pt' => 'Pasta dos pais',
                    'es' => 'carpeta principal',
                    'de' => 'übergeordneter Ordner',
                ],
            ],
            'folders' => [
                'image' => [
                    'fr' => 'Image',
                    'en' => 'Image',
                    'nl' => 'Afbeelding',
                    'pt' => 'Imagem',
                    'es' => 'Imagen',
                    'de' => 'Bild',
                ],
                'is_media_folder' => [
                    'fr' => 'Dossier médiathèque',
                    'en' => 'Media library folder',
                    'nl' => 'Map voor mediabibliotheek',
                    'pt' => 'Dossier médiathèque',
                    'es' => 'Carpeta de la biblioteca de medios',
                    'de' => 'Ordner Medienbibliothek',
                ],
                'folders' => [
                    'fr' => 'Dossier parent',
                    'en' => 'Parent folder',
                    'nl' => 'Bovenliggende map',
                    'pt' => 'Pasta dos pais',
                    'es' => 'carpeta principal',
                    'de' => 'übergeordneter Ordner',
                ],
                'color' => [
                    'fr' => 'Couleur',
                    'en' => 'Color',
                    'nl' => 'Kleur',
                    'pt' => 'Cor',
                    'es' => 'Color',
                    'de' => 'Farbe',
                ],
                'weight' => [
                    'fr' => 'Ordre d\'affichage pour les dossier sans parent',
                    'en' => 'Order of appearance',
                    'nl' => 'Weergavevolgorde voor mappen zonder bovenliggende mappen',
                    'pt' => 'Ordem de exibição de pastas sem pai',
                    'es' => 'orden de aparición',
                    'de' => 'Reihenfolge des Erscheinens',
                ]
            ],
            'tabs_spaces' => [
                'banner' => [
                    'fr' => 'Bannière',
                    'en' => 'Banner',
                    'nl' => 'Banier',
                    'pt' => 'Bandeira',
                    'es' => 'Bandera',
                    'de' => 'Banner',
                ],
                'introduction' => [
                    'fr' => 'Introduction',
                    'en' => 'Introduction',
                    'nl' => 'Invoering',
                    'pt' => 'Introdução',
                    'es' => 'Introducción',
                    'de' => 'Einführung',
                ],
                'color' => [
                    'fr' => 'Couleur du titre et de l’introduction',
                    'en' => 'Title and introduction color',
                    'es' => 'Color del título y la introducción',
                    'pt' => 'Cor do título e da introdução',
                    'de' => 'Farbe von Titel und Einleitung',
                    'nl' => 'Kleur van titel en inleiding',
                ],
            ],
            'cards_links' => [
                'link' => [
                    'fr' => 'Lien',
                    'en' => 'Link',
                    'nl' => 'Link',
                    'pt' => 'Link',
                    'es' => 'Enlace',
                    'de' => 'Link',
                ],
                'image' => [
                    'fr' => 'Image',
                    'en' => 'Picture',
                    'nl' => 'Afbeelding',
                    'pt' => 'Foto',
                    'es' => 'Imagen',
                    'de' => 'Bild',
                ],
                'weight' => [
                    'fr' => 'Ordre d\'affichage',
                    'en' => 'Display order',
                    'nl' => 'Weergavevolgorde',
                    'pt' => 'Ordem de exibição',
                    'es' => 'Orden de visualización',
                    'de' => 'Reihenfolge anzeigen',
                ],
                'is_featured' => [
                    'fr' => 'Mis en avant ?',
                    'en' => 'Featured?',
                    'nl' => 'Uitgelicht?',
                    'pt' => 'Apresentou?',
                    'es' => '¿Presentado?',
                    'de' => 'Vorgestellt?',
                ],
            ],
            'news_categories_listings' => [
                'introduction' => [
                    'fr' => 'Introduction',
                    'en' => 'Introduction',
                    'es' => 'Introducción',
                    'pt' => 'Introdução',
                    'de' => 'Einführung',
                    'nl' => 'Inleiding',
                ],
                'color' => [
                    'fr' => 'Couleur du titre et de l’introduction',
                    'en' => 'Title and introduction color',
                    'es' => 'Color del título e introducción',
                    'pt' => 'Cor do título e introdução',
                    'de' => 'Farbe von Titel und Einführung',
                    'nl' => 'Kleur van titel en inleiding',
                ],
                'filter_format' => [
                    'fr' => 'Format du filtre',
                    'nl' => 'Filterformaat',
                    'de' => 'Filterformat',
                    'es' => 'Formato del filtro',
                    'en' => 'Filter format',
                    'pt' => 'Formato do filtro',
                ],
                'news_view_mode' => [
                    'fr' => 'Affichage des news',
                    'nl' => 'Nieuwsweergave',
                    'de' => 'Nachrichtenanzeige',
                    'es' => 'Visualización de noticias',
                    'en' => 'News display',
                    'pt' => 'Exibição de notícias',
                ],
                'add_search_bar' => [
                    'fr' => 'Ajouter une barre de recherche',
                    'nl' => 'Een zoekbalk toevoegen',
                    'de' => 'Suchleiste hinzufügen',
                    'es' => 'Agregar una barra de búsqueda',
                    'en' => 'Add a search bar',
                    'pt' => 'Adicionar uma barra de pesquisa',
                ],
            ],
            'tools_categories_listings' => [
                'banner' => [
                    'fr' => 'Bannière',
                    'en' => 'Banner',
                    'es' => 'Banner',
                    'pt' => 'Banner',
                    'de' => 'Banner',
                    'nl' => 'Banner',
                ],
                'introduction' => [
                    'fr' => 'Introduction',
                    'en' => 'Introduction',
                    'es' => 'Introducción',
                    'pt' => 'Introdução',
                    'de' => 'Einführung',
                    'nl' => 'Inleiding',
                ],
                'color' => [
                    'fr' => 'Couleur du titre et de l’introduction',
                    'en' => 'Title and introduction color',
                    'es' => 'Color del título e introducción',
                    'pt' => 'Cor do título e introdução',
                    'de' => 'Farbe von Titel und Einführung',
                    'nl' => 'Kleur van titel en inleiding',
                ],
            ],
            'external_notifications' => [
                'external_notif_link' => [
                    'fr' => 'Lien',
                    'en' => 'Link',
                    'de' => 'Link',
                    'es' => 'Enlace',
                    'nl' => 'Link',
                    'pt' => 'Ligação',
                ],
                'image' => [
                    'fr' => 'Image',
                    'en' => 'Image',
                    'de' => 'Bild',
                    'es' => 'Imagen',
                    'nl' => 'Afbeelding',
                    'pt' => 'Imagem',
                ],
            ],
            'tabs' => [
                'icon' => [
                    'fr' => 'Icone',
                    'en' => 'Icon',
                    'nl' => 'Icon',
                    'pt' => 'ícone',
                    'es' => 'icono',
                    'de' => 'Symbol',
                ],
                'icon_color' => [
                    'fr' => 'Couleur de l\'icône',
                    'en' => 'Icon color',
                    'nl' => 'Pictogramkleur',
                    'pt' => 'Cor do ícone',
                    'es' => 'Color del icono',
                    'de' => 'Symbolfarbe',
                ],
                'tabs_spaces' => [
                    'fr' => 'Espace à onglets',
                    'en' => 'Tabbed space',
                    'nl' => 'Ruimte met tabbladen',
                    'pt' => 'Espaço com guias',
                    'es' => 'Espacio con pestañas',
                    'de' => 'Leerzeichen mit Tabs',
                ],
                'weight' => [
                    'fr' => 'Ordre d\'affichage',
                    'en' => 'Display order',
                    'nl' => 'Weergavevolgorde',
                    'pt' => 'Ordem de exibição',
                    'es' => 'Orden de visualización',
                    'de' => 'Reihenfolge anzeigen',
                ],
            ],
            'tools' => [
                'tools_categories' => [
                    'fr' => 'Catégorie d\'outil',
                    'en' => 'Tool category',
                    'nl' => 'Categorie gereedschap',
                    'pt' => 'Categoria de ferramenta',
                    'es' => 'Categoría de herramienta',
                    'de' => 'Werkzeugkategorie',
                ],
                'icon' => [
                    'fr' => 'Icone',
                    'en' => 'Icon',
                    'nl' => 'Icon',
                    'pt' => 'Ícone',
                    'es' => 'Icono',
                    'de' => 'Symbol',
                ],
                'icon_color' => [
                    'fr' => 'Couleur de l\'icône',
                    'en' => 'Icon color',
                    'nl' => 'Pictogramkleur',
                    'pt' => 'Cor do ícone',
                    'es' => 'Color del icono',
                    'de' => 'Symbolfarbe',
                ],
                'image' => [
                    'fr' => 'Image',
                    'en' => 'Image',
                    'nl' => 'Afbeelding',
                    'pt' => 'Imagem',
                    'es' => 'Imagen',
                    'de' => 'Bild',
                ],
                'tools_link' => [
                    'fr' => 'Lien',
                    'en' => 'Link',
                    'nl' => 'Link',
                    'pt' => 'Ligação',
                    'es' => 'Enlace',
                    'de' => 'Verknüpfung',
                ],
                'content' => [
                    'fr' => 'Contenu',
                    'en' => 'Content',
                    'nl' => 'Inhoud',
                    'pt' => 'Conteúdo',
                    'es' => 'Contenido',
                    'de' => 'Inhalt',
                ],
                'weight' => [
                    'fr' => 'Ordre d\'affichage',
                    'en' => 'order of appearance',
                    'nl' => 'Weergavevolgorde',
                    'pt' => 'Ordem de exibição',
                    'es' => 'orden de aparición',
                    'de' => 'Reihenfolge des Erscheinens',
                ],
            ],
            'homepage_entities' => [
                'image' => [
                    'fr' => 'Image',
                    'en' => 'Image',
                    'es' => 'Imagen',
                ],
                'entity_navigation_page' => [
                    'fr' => 'Entiité',
                    'en' => 'Entity',
                    'es' => 'Entidad',
                ],
                'weight' => [
                    'fr' => 'Ordre d\'affichage',
                    'en' => 'Display order',
                    'es' => 'Orden de visualización',
                ],
            ],
            'entity_navigation_page' => [
                'banner' => [
                    'fr' => 'Bannière',
                    'en' => 'Banner',
                    'es' => 'Bandera',
                ],
                'introduction' => [
                    'fr' => 'Introduction',
                    'en' => 'Introduction',
                    'es' => 'Introducción',
                ]
                ],
                'custom' => [
                    'banner' => [
                        'fr' => 'Bannière',
                        'en' => 'Banner',
                        'es' => 'Banner',
                        'pt' => 'Banner',
                        'de' => 'Banner',
                        'nl' => 'Banner',
                    ],
                    'introduction' => [
                        'fr' => 'Introduction',
                        'en' => 'Custom page',
                        'es' => 'Página personalizada',
                        'pt' => 'Página personalizada',
                        'de' => 'Benutzerdefinierte Seite',
                        'nl' => 'Pagina op maat',
                    ],
                    'redirection_page' => [
                        'fr' => 'Page de redirection',
                        'en'=>'Redirection page',
                        'es'=>'Redirigir página',
                        'pt'=>'Página de redireccionamento',
                        'de'=>'Weiterleitungsseite',
                        'nl'=>'Pagina doorsturen',
                    ],
                    'custom_slug' => [
                        'fr' => 'Slug custom',
                        'en'=>'Custom slug',
                        'es'=>'Babosa personalizada',
                        'pt'=>'Lesma personalizada',
                        'de'=>'Slug custom',
                        'nl'=>'Slak op maat',
                    ],
                    'color' => [
                        'fr' => 'Couleur du titre de la page',
                        'en' => 'Page title color',
                        'es' => 'Color del título de la página',
                        'pt' => 'Cor do título da página',
                        'de' => 'Farbe des Seitentitels',
                        'nl' => 'Kleur van de paginatitel',
                    ]
                ],
                'public_pages' => [
                    'content' => [
                        'fr' => 'Contenu',
                        'en' => 'Content',
                        'de' => 'Inhalt',
                        'es' => 'Contenido',
                        'pt' => 'Conteúdo',
                    ],
                ],
                'pages' => [
                    'banner' => [
                        'fr' => 'Bannière',
                        'en' => 'Banner',
                        'es' => 'Banner',
                        'pt' => 'Banner',
                        'de' => 'Banner',
                        'nl' => 'Banner',
                    ],
                    'chapo' => [
                        'fr' => 'Introduction',
                        'en' => 'Introduction',
                        'es' => 'Introducción',
                        'nl' => 'Inleiding',
                        'de' => 'Einführung',
                        'pt' => 'Introdução',
                    ],
                    'color' => [
                        'fr' => 'Couleur du titre et de l’introduction',
                        'en' => 'Title and introduction color',
                        'es' => 'Color del título y la introducción',
                        'pt' => 'Cor do título e da introdução',
                        'de' => 'Farbe von Titel und Einleitung',
                        'nl' => 'Kleur van titel en inleiding',
                    ],
                    'content' => [
                        'fr' => 'Contenu',
                        'en' => 'Content',
                        'es' => 'Contenido',
                        'pt' => 'Conteúdo',
                        'de' => 'Inhalt',
                        'nl' => 'Inhoud',
                    ],
                ],
                'connexion_popups' => [
                    'content' => [
                        'fr' => 'Contenu',
                        'en' => 'Content',
                        'es' => 'Contenido',
                        'pt' => 'Conteúdo',
                        'de' => 'Inhalt',
                        'nl' => 'Inhoud',
                    ],
                ],
                'tabs_pages' => [
                    'tabs' => [
                        'fr' => 'Onglets',
                        'en' => 'Tabs',
                        'nl' => 'Tabbladen',
                        'pt' => 'Guias',
                        'es' => 'Categoría de pestañas',
                        'de' => 'Tabs',
                    ],
                    'content' => [
                        'fr' => 'Contenu',
                        'en' => 'Content',
                        'nl' => 'Inhoud',
                        'pt' => 'Entusiasmado',
                        'es' => 'Encantado',
                        'de' => 'Begeistert',
                    ],
                    'weight' => [
                        'fr' => 'Ordre d\'affichage',
                        'en' => 'Display order',
                        'nl' => 'Weergavevolgorde',
                        'pt' => 'Ordem de exibição',
                        'es' => 'Orden de visualización',
                        'de' => 'Reihenfolge anzeigen',
                    ]
                ]

        ];

        foreach ($types as $type => $translations) {
            InsideSchema::setModelOption($type, 'title', $translations);
        }

        foreach ($fields as $contentType => $field) {
            foreach ($field as $fieldName => $translations) {
                InsideSchema::updateFieldOption($contentType, $fieldName, 'title', $translations);
            }
        }
    }
}
