<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;

class HideUnnecessaryContentTypes extends Migration
{
    public function up(): void
    {
        $contentTypes = [
            'news_categories',
            'news',
            'events_categories',
            'events',
            'dms_link',
            'faq_categories',
            'faq_questions',
            'flash_news',
            'movements_categories',
            'movements',
            'blocks',
            'news_categories_listings'
        ];

        $bridgeContentType = new BridgeContentType();
        foreach ($contentTypes as $contentType) {
            if (Schema::hasContentType($contentType)) {
                $options = Schema::getModelOptions($contentType);
                $listingType = $options['listing_type'];
                if ($listingType !== 'hidden') {
                    $bridgeContentType->updateContentTypeOptions(
                        type: $contentType,
                        options: [
                            'listing_type' => 'hidden',
                            'searchable' => false,
                        ]
                    );
                }
            }
        }
    }
}
