<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Models\Content;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Facades\Schema;

class MakeTabsPagesAliasable extends Migration
{
    public function up(): void
    {
        if (
            ! Schema::hasContentType('tabs_pages')
        ) {
            return;
        }
        $bridge = new BridgeContentType();

        $bridge->updateContentTypeOptions(
            type: 'tabs_pages',
            options: [
                'aliasable' => true,
            ]
        );

        type_to_class('tabs_pages')::all()->each(function (Content $tabsPages) {
            $tabsPages->buildSlug();
        });

        Artisan::call('models:rebuild');
    }
}
