<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'tabs_pages',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => true,
        'aliasable' => false,
        'permissible' => true,
        'categorizable' => false,
        'listing_type' => 'content',
        'title' => [
            'fr' => 'Sous Page Onglet',
            'en' => 'Sub Page Tab',
            'nl' => 'Tabblad Subpagina',
            'pt' => 'Guia Subpágina',
            'es' => 'Pestaña de subpágina',
            'de' => 'Registerkarte „Unterseite“.',
        ],
    ],
    'fields' => [
        [
            'name' => 'tabs',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Onglets',
                'en' => 'Tabs',
                'nl' => 'Tabbladen',
                'pt' => 'Guias',
                'es' => 'Categoría de pestañas',
                'de' => 'Tabs',
            ],
            'description' => [
                'fr' => 'Choix de l\'onglet dans laquelle l\'onglet doit remonter',
                'en' => 'Choice of the tab in which the tab should go up',
                'nl' => 'Keuze van het tabblad waarin het tabblad omhoog moet gaan',
                'pt' => 'Escolha da aba em que a aba deve subir',
                'es' => 'Elección de la pestaña en la que debe subir la pestaña',
                'de' => 'Auswahl der Registerkarte, in der die Registerkarte angezeigt werden soll',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['tabs'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'content',
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Contenu',
                'en' => 'Content',
                'nl' => 'Inhoud',
                'pt' => 'Entusiasmado',
                'es' => 'Encantado',
                'de' => 'Begeistert',
            ],
            'widget' => [
                'type' => BridgeContentType::SECTION_WIDGET,
                'settings' => [
                    'title' => 'Paragraphe',
                    'title_plural' => 'Paragraphes',
                    'edit_mode' => 'open',
                    'add_mode' => 'dropdown',
                    'form_display_mode' => 'default',
                    'default_paragraph_type' => '',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::SECTION_FIELD,
            'settings' => [
                'target_type' => [
                    'text',
                    'text_two_columns',
                    'text_with_image',
                    'separator',
                    'file',
                    'slider',
                    'image',
                    'video',
                    'map',
                    'accordion',
                    'call_to_action',
                    'button',
                    'html',
                    'tweet',
                    'fetched_contents',
                ],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'weight',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Ordre d\'affichage',
                'en' => 'Display order',
                'nl' => 'Weergavevolgorde',
                'pt' => 'Ordem de exibição',
                'es' => 'Orden de visualización',
                'de' => 'Reihenfolge anzeigen',
            ],
            'description' => [
                'fr' => 'Le chiffre le plus bas remonte en 1er',
                'en' => 'The lowest number goes back to 1st',
                'nl' => 'Het laagste getal gaat naar 1e',
                'pt' => 'O número mais baixo vai para o 1º',
                'es' => 'El número más bajo va al 1.º',
                'de' => 'Die niedrigste Zahl geht an den 1. Platz',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => 2,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => 0,
        ],
    ],
];
