<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'homepage_entities',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => true,
        'aliasable' => false,
        'permissible' => true,
        'categorizable' => true,
        'listing_type' => 'content',
        'title' => [
            'fr' => 'Page d\'accueil des 3 entités',
            'en' => 'Entity home page',
            'es' => 'Página de navegación de entidades',
        ],
    ],
    'fields' => [
        [
            'name' => 'image',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Image',
                'en' => 'Image',
                'es' => 'Imagen',
            ],
            'description' => [
                'fr' => 'Cette image remontera comme une bannière du bloc',
                'en' => 'This image will be displayed as the banner for the block.',
                'es' => 'Esta imagen aparecerá como el banner del bloque',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 0,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'entity_navigation_page',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 1,
            'title' => [
                'fr' => 'Entiité',
                'en' => 'Entity',
                'es' => 'Entidad',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['entity_navigation_page'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ],
        [
            'name' => 'weight',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Ordre d\'affichage',
                'en' => 'Display order',
                'es' => 'Orden de visualización',
            ],
            'description' => [
                'fr' => 'Le chiffre le plus bas remonte en 1er',
                'en' => 'The lowest number goes back to 1st',
                'es' => 'El número más bajo vuelve al 1º',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => 2,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => 0,
        ],
    ],
];
