<?php

return [
    'manual_notifications' => [
        'enabled' => true,
        'enhanced_notifications' => true,
        'enhanced_notifications_types_and_fields' => [
            'news' => [
                'fields' => [
                    'image',
                    'chapo'
                ]
            ],
            'pages' => [
                'fields' => [
                    'banner',
                    'chapo',
                ]
            ],
            'tabs_spaces' => [
                'fields' => [
                    'banner',
                    'introduction',
                ]
            ],
            'external_notifications' => [
                'fields' => [
                    'image',
                ],
            ],
        ],
        'enabled_types' => [
            'news',
            'pages',
            'tabs_spaces',
            'tabs_pages',
            'documents',
            'external_notifications',
        ],
        'contents_url_field' => [
            'external_notifications' => 'external_notif_link',
        ],
        'custom_url' => function ($channel, $type, $uuid) {
            return match ($type) {
                'tabs_pages' => 'CUSTOM:tabs_pages',
                default => null,
            };
        },
    ],
    'build_url_callbacks' => [
        'tabs_pages' => function ($model) {
            return data_get($model, 'slug.0');
        }
    ],
];
