<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Content\Models\Contents\Custom;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class EnableNewsAndNewsCategoriesTypes extends Migration
{
    private BridgeContent $bridge;

    private function getBridge(): BridgeContent
    {
        return $this->bridge ??= new BridgeContent();
    }

    public function up(): void
    {
        $mainLanguage = config('app.locale');
        $otherLanguages = collect(list_languages())->reject($mainLanguage)->values();

        $newsCustomPage = [
            'title' => [
                'fr' => 'Actualités',
                'en' => 'News',
                'es' => 'Noticias',
                'pt' => 'Notícias',
                'de' => 'Nachrichten',
                'nl' => 'Nieuws',
            ],
            'redirection_page' => 'NewsListingPage',
            'custom_slug' => 'news',
        ];

        $uuidHost = $this->createIfNotExists(
            [
                'title' => $newsCustomPage['title'][$mainLanguage],
                'redirection_page' => $newsCustomPage['redirection_page'],
                'custom_slug' => $newsCustomPage['custom_slug'],
                'langcode' => $mainLanguage,
            ],
            $mainLanguage,
            true
        );

        if (! $uuidHost) {
            throw new Exception('News custom page not created');
        }

        foreach ($otherLanguages as $language) {
            if (! isset($newsCustomPage['title'][$language])) {
                continue;
            }

            $translatedContent = [
                'title' => $newsCustomPage['title'][$language],
                'redirection_page' => $newsCustomPage['redirection_page'],
                'custom_slug' => $newsCustomPage['custom_slug'],
                'langcode' => $language,
                'uuid_host' => $uuidHost,
            ];

            $this->createIfNotExists($translatedContent, $language, false);
        }

        $bridgeContentType = new BridgeContentType();
        $bridgeContentType->updateContentTypeOptions('news_categories', ['listing_type' => 'content', 'searchable' => true]);
        $bridgeContentType->updateContentTypeOptions('news', ['listing_type' => 'content']);
    }

    private function createIfNotExists(array $preparedData, string $language, bool $isHostContent): ?string
    {
        $hostUuid = null;
        $customPageTest = Custom::where(['redirection_page' => $preparedData['redirection_page'], 'langcode' => $language])->first();

        if ($customPageTest) {
            if ($customPageTest->status === false) {
                $this->getBridge()->contentUpdate($customPageTest->content_type, ['bundle' =>  $customPageTest->contentType, 'uuid' => $customPageTest->uuid, 'status' => true]);
            }
            return $customPageTest->uuid_host;
        }

        $newCustomPageUuid = $this->getBridge()->contentInsert('custom', $preparedData);

        return $isHostContent ? Custom::find($newCustomPageUuid)?->uuid_host : null;
    }
}
