<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;

class MakeDocumentsGlobalSearchable extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();
        $bridge->updateContentTypeOptions(
            type: 'documents',
            options: [
                'searchable' => true,
                'global_searchable' => true,
            ]
        );

        Artisan::call('models:rebuild');
        Artisan::call('index:rebuild', ['--type' => 'documents']);
    }
}
