<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'navigation_card',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => true,
        'aliasable' => false,
        'permissible' => false,
        'categorizable' => false,
        'listing_type' => 'content',
        'title' => [
            'fr' => 'Carte navigation',
            'en' => 'Navigation card',
            'es' => 'Carta de navegación',
        ],
    ],
    'fields' => [
        [
            'name' => 'image',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Image',
                'en' => 'Image',
                'es' => 'Imagen',
            ],
            'description' => [
                'fr' => 'Cette image remontera comme une bannière du bloc',
                'en' => 'This image will be displayed as the banner for the block.',
                'es' => 'Esta imagen aparecerá como el banner del bloque',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 0,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'entity_navigation_page',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Entité',
                'en' => 'Entity',
                'es' => 'Entidad',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['entity_navigation_page'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'tabs_spaces',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 2,
            'title' => [
                'fr' => 'Espace à onglets',
                'en' => 'Tabbed space',
                'es' => 'espacio de tabulación',
            ],
            'description' => [
                'fr' => 'Choix de l\'espace dans laquelle l\'onglet doit remonter',
                'en' => 'Choice of the area where the tab should appear',
                'es' => 'Selección del área donde la pestaña debe mostrarse.',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 2,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['tabs_spaces'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'weight',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 3,
            'title' => [
                'fr' => 'Ordre d\'affichage',
                'en' => 'Display order',
                'es' => 'Orden de visualización',
            ],
            'description' => [
                'fr' => 'Le chiffre le plus bas remonte en 1er',
                'en' => 'The lowest number goes back to 1st',
                'es' => 'El número más bajo vuelve al 1º',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => 3,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => 0,
        ],
    ],
];
