<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'full_page_block',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => true,
        'aliasable' => false,
        'permissible' => false,
        'categorizable' => true,
        'listing_type' => 'content',
        'title' => [
            'fr' => 'Carte pleine page',
            'en' => 'Full-page block',
            'es' => 'Bloque a toda página',
        ],
    ],
    'fields' => [
        [
            'name' => 'image',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Image',
                'en' => 'Image',
                'es' => 'Imagen',
            ],
            'description' => [
                'fr' => 'Cette image remontera comme une bannière du bloc',
                'en' => 'This image will be displayed as the banner for the block.',
                'es' => 'Esta imagen aparecerá como el banner del bloque',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 0,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'entity_navigation_page',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Entité',
                'en' => 'Entity',
                'es' => 'Entidad',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['entity_navigation_page'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'tabs_spaces',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 2,
            'title' => [
                'fr' => 'Espace à onglets',
                'en' => 'Tabbed space',
                'es' => 'espacio de tabulación',
            ],
            'description' => [
                'fr' => 'Choix de l\'espace dans laquelle l\'onglet doit remonter',
                'en' => 'Choice of the area where the tab should appear',
                'es' => 'Selección del área donde la pestaña debe mostrarse.',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 2,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['tabs_spaces'],
                'cardinality' => 1,
            ],
        ],
    ],
];
