export default {
  globals: {
    calendarExportTypes: [
      {
        type: 'ics',
        label: 'iCalendar'
      }
    ]
  },
  'inside-events': {
    subscriptionEnabled: true,
    bookmarkEnabled: true,
    showBookmarks: true
  },
  'inside-ged': {
    useBookmarks: true
  },
  'inside-news': {
    minimalDate: true,
    bookmarkEnabled: true,
    showBookmarks: true
  },
  'inside-users': {
    shortcuts: {
      max: 8,
      readonlyCount: 4
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'bookmarks', restrictions: [], icon: 'bookmark' },
        { name: 'notifications', restrictions: [], icon: 'settings' }
      ]
    },
    paragraphs: {
      fetchedContents: {
        display: () => import('../inside-customs/components/users/Card'),
        requestFields: [
          'uuid',
          'firstname',
          'lastname',
          'image',
          'function'
        ]
      }
    }
  }
}
