<?php

return [
    '_meta' => [
        'type' => 'newsletters',
        'fieldsPrefix' => ''
    ],
    'logo' => [
        'showLogo'  => true,
        'logoUrl'   => 'vendor/maecia/estp-back/resources/assets/img/newsletter/logo.png',
        'logoWidth' => 200
    ],
    'banner'       => [
        'backgroundImageUrl' => 'vendor/maecia/estp-back/resources/assets/img/newsletter/bg.jpg',
        'backgroundColor' => '#ffff'
    ],
    'introduction' => [
        'introductionFieldName' => 'newsletter_introduction',
        'textColor' => '#2C3E50'
    ],
    'sections'     => [
        'news'       => [
            'sectionTitleStrKey' => 'newsletter.news_title',
            'types' => ['news'],
            'dateFormat' => '%d/%m/%Y',
            'showCategoryTitle' => true,
            'defaultCategoryColor' => '#EA9675',
            'link' => [
                'sectionLinkUrl'  => 'actualites',
                'sectionTextColor' => '#2C3E50',
            ],
        ],
        'events'     => [
            'sectionTitleStrKey' => 'newsletter.events_title',
            'types' => ['events'],
            'sorts' => ['date:desc'],
            'dateFormat' => '%d/%m/%Y',
            'categoryFieldName' => 'events_categories',
            'defaultCategoryColor' => '#479280',
            'link' => [
                'sectionLinkUrl'   => 'events',
                'sectionTextColor' => '#2C3E50',
            ],
        ],
        'documents'  => [
            'sectionTitleStrKey' => 'newsletter.documents_title',
            'types'           => ['documents'],
            'sorts' => ['created_at:desc'],
            'imageStyle' => 'medium',
            'dateFormat' => '%d/%m/%Y',
            'link'            => [
                'sectionLinkStrKey' => 'newsletter.see_all_documents',
                'sectionLinkUrl' => 'bibliotheque',
                'sectionTextColor' => '#2C3E50'
            ],
        ]
    ],
    'socials'      => [
        'backgroundColor' => '#000000',
        'links' => [
            'facebook' => [
                'url' => 'http://www.facebook.com/estpparis',
            ],
            'twitter' => [
                'url' => 'https://twitter.com/estp_officiel',
            ],
            'linkedin' => [
                'url' => 'https://www.linkedin.com/company/estp/',
            ],
            'instagram' => [
                'url' => 'https://www.instagram.com/estp_officiel/',
            ]
        ],
    ],
    'footer'       => [
        'backgroundColor' => '#ffffff',
        'unsubscribeTextColor' => '#2C3E50',
        'unsubscribeTextStrKey' => 'newsletter.unsubscribe.warning'
    ],
];
