<?php

use Illuminate\Support\Facades\Artisan;
use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;
use Inside\Content\Models\Contents\Tools;
use Inside\Content\Models\Contents\Users;

class UpdateQuickAccess extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();

        $toolUuids = Tools::query()->whereIn('title', [
            'Teams',
            'Outlook',
            'E-pointage',
            'Mon ADP'
        ])->pluck('uuid_host')
            ->toArray();

        $users = Users::all()->each(
            fn ($user) => $bridge->updateReferenceFields(
                type: 'users',
                contentUuidHost: $user->uuid_host,
                data: [
                    'tools' => $toolUuids
                ]
            )
        );
    }
}
