<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class SetPostingsCategoriesRefToMultipleFixUsersFields extends Migration
{
    public const FIELDS_TO_DELETE = [
        [
            'entityType' => 'user',
            'contentType' => 'user',
            'field' => 'user_type',
        ],
        [
            'entityType' => 'node',
            'contentType' => 'postings',
            'field' => 'postings_categories',
        ]
    ];

    public function up(): void
    {
        $bridge = new BridgeContentType();

        collect(self::FIELDS_TO_DELETE)
            ->each(fn ($data) => $bridge->contentTypeDeleteField($data['entityType'], $data['contentType'], $data['field']));

        $bridge->contentTypeCreateOrUpdateField('postings', 'postings_categories', [
            'name' => 'postings_categories',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 3,
            'title' => [
                'fr' => 'Catégorie d\'annonces',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 3,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['postings_categories'],
                'cardinality' => 1,
            ],
        ]);
    }
}
