<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Migrations\CreateContentTypes;
use Inside\Content\Facades\ContentBlueprints;

class CreateContentType extends Migration
{
    use CreateContentTypes;

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('companies', false);
        $this->migrateContent('user_types', false);
        $this->migrateContent('locations', false);
        $this->migrateContent('tools_categories', false);
        $this->migrateContent('tools', false);
        $this->migrateContent('users', false);
        $this->migrateContent('news_categories', false);
        $this->migrateContent('news', false);
        $this->migrateContent('events_categories', false);
        $this->migrateContent('events', false);
        $this->migrateContent('folders', false);
        $this->migrateContent('documents', false);
        $this->migrateContent('blocks', false);
        $this->migrateContent('cards_links', false);
        $this->migrateContent('space_categories', false);
        $this->migrateContent('tabs_spaces', false);
        $this->migrateContent('tabs', false);
        $this->migrateContent('tabs_pages', false);
        $this->migrateContent('postings_categories', false);
        $this->migrateContent('postings', false);

        ContentBlueprints::generateContent('faq_categories');
        ContentBlueprints::generateContent('faq_questions');

        ContentBlueprints::generateContent('flash_news');

        $this->finishUp();
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
    }
}
