<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class FixFrontFeedbacks extends Migration
{
    public const FIELDS_TO_DELETE = [
        [
            'entityType' => 'user',
            'contentType' => 'user',
            'field' => 'manager',
        ],
        [
            'entityType' => 'user',
            'contentType' => 'user',
            'field' => 'mobile',
        ],
        [
            'entityType' => 'node',
            'contentType' => 'postings',
            'field' => 'recipient',
        ],
        [
            'entityType' => 'node',
            'contentType' => 'postings',
            'field' => 'locations',
        ],
        [
            'entityType' => 'node',
            'contentType' => 'postings',
            'field' => 'brief',
        ]
    ];

    public const POSTINGS_FIELDS_TO_CREATE = [
        [
            'field' => 'postings_location',
            'weight' => 2,
            'title' => 'Localisation',
            'description' => '',
        ],
        [
            'field' => 'contact',
            'weight' => 4,
            'title' => 'Destinataire',
            'description' => 'Indiquez votre mail pour que l\'on puisse vous contacter',
        ]
    ];

    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->changeFieldTitle('dms_link', 'folders', ['fr' => "Dossier parent"]);

        $bridge->updateFieldOptions('postings', 'postings_categories', [
            'settings' => [
                'cardinality' => 1
            ]
        ]);

        collect(self::FIELDS_TO_DELETE)
            ->each(fn ($data) => $bridge->contentTypeDeleteField($data['entityType'], $data['contentType'], $data['field']));

        collect(self::POSTINGS_FIELDS_TO_CREATE)
            ->each(fn ($data) => $bridge->contentTypeCreateOrUpdateField('postings', $data['field'], [
                'name' => $data['field'],
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => $data['weight'],
                'title' => [
                    'fr' => $data['title'],
                ],
                'description' => [
                    'fr' => $data['description'],
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => $data['weight'],
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ]));

        $bridge->contentTypeCreateOrUpdateField('postings', 'summary', [
            'name' => 'summary',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Résumé',
            ],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows' => 5,
                    'placeholder' => '',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ]);

        $bridge->contentTypeCreateOrUpdateField('tabs_spaces', 'preview_image', [
            'name' => 'preview_image',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 4,
            'title' => [
                'fr' => 'Image d\'aperçu',
            ],
            'description' => [
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 4,
            ],
            'type' => BridgeContentType::IMAGE_FIELD,
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ]);
    }
}
