<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Illuminate\Support\Facades\Schema;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Layout\Models\LayoutPath;
use Inside\Host\Bridge\BridgeContent;
use Inside\Content\Models\Contents\Quiz;
use Inside\Settings\Models\Setting;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Models\Model;
use Inside\Layout\Repositories\Contracts\LayoutRepositoryInterface;

class CleaningAfterRemovingInsideQuiz extends Migration
{
    public const TABLES_TO_DELETE = ['inside_quiz_answers', 'inside_quiz_scores', 'node__field_quiz_background_color',
        'node__field_quiz_description', 'node__field_quiz_end_date', 'node__field_quiz_end_description', 'node__field_quiz_end_title',
        'node__field_quiz_image', 'node__field_quiz_show_average', 'node__field_quiz_show_final_score', 'node__field_quiz_unique_submission',
        'inside_content_quiz', 'node_revision__field_quiz_background_color', 'node_revision__field_quiz_description',
        'node_revision__field_quiz_end_date', 'node_revision__field_quiz_end_description', 'node_revision__field_quiz_end_title',
        'node_revision__field_quiz_image', 'node_revision__field_quiz_show_average', 'node_revision__field_quiz_show_final_score',
        'node_revision__field_quiz_unique_submission'];

    public const MIGRATIONS_TO_DELETE = [
        '2021_05_17_000000_add_quiz_content_type', '2021_05_24_000000_create_quiz_answers_table',
        '2021_05_24_000000_create_quiz_scores_table', '2021_05_25_000000_add_export_notification_type',
        '2021_09_17_000000_fix_fields_typos_in_titles', '2022_01_10_00000_add_field_is_anonymous'
    ];

    public function up(): void
    {
        $bridgeContentType = new BridgeContentType();
        if (! InsideSchema::hasModel('quiz')) {
            return;
        }

        $bridgeContentType->contentTypeDelete('quiz');

        $bridgeContent = new BridgeContent();
        Quiz::select('uuid')->each(fn ($quiz) => $bridgeContent->contentDelete('quiz', $quiz->uuid));

        $bridgeContentType->contentTypeDelete('quiz');

        collect(self::TABLES_TO_DELETE)->each(function ($table) {
            DB::statement('SET FOREIGN_KEY_CHECKS=0');
            Schema::dropIfExists($table);
            DB::statement('SET FOREIGN_KEY_CHECKS=1');
        });

        collect(self::MIGRATIONS_TO_DELETE)->each(fn ($migration) => DB::table('migrations')->where('migration', 'like', "%{$migration}%")->delete());

        Artisan::call('models:rebuild');

        Model::query()->where('class', type_to_class('quiz'))->delete();
        Artisan::call('index:rebuild');
    }
}
