<?php

use Illuminate\Support\Arr;
use Illuminate\Support\Collection;
use Illuminate\Support\Str;
use Inside\Content\Models\Contents\Users;

return [
    'sync_attributes' => [
        'mail' => 'mail',
        'name' => 'mail',
        'lastname' => 'surname',
        'firstname' => 'givenName',
        'phone' => fn (mixed $user) =>  Arr::first($user->businessPhones),
        'mobile_phone' => fn (mixed $user) => $user->mobilePhone,
        'function' => 'jobTitle',
        'companies' => fn (mixed $user) => reference('companies')
            ->identifiedBy('code')
            ->from(Str::ucfirst(trim(Str::lower($user->department))))
            ->get(),
        'locations' => fn (mixed $user) => reference('locations')
            ->identifiedBy('code')
            ->from(Str::ucfirst(trim(Str::lower($user->city))))
            ->get(),
        'offices' => fn (mixed $user) => reference('offices')
            ->identifiedBy('code')
            ->from(Str::ucfirst(trim(Str::lower($user->officeLocation))))
            ->get(),
        'user_types' => fn (mixed $user) => reference('user_types')
            ->identifiedBy('code')
            ->from(Str::ucfirst(trim(Str::lower($user->onPremisesExtensionAttributes->extensionAttribute6))))
            ->get(),
        'manager' => fn (mixed $user) => reference('users')
            ->identifiedBy('email')
            ->from(ucfirst(trim($user->manager)))
            ->withoutCreation()
            ->get(),
        'status' => fn () => 1,
        'is_maintenance' => 'isMaintenance',
    ],
    'custom_attributes' => [
        'manager' => 'mail',
    ],
    'postfilter' => function (Collection $users) {
        $maintenances = Users::all()->where('is_maintenance', true)->pluck('email');

        return $users->map(function ($user) use ($maintenances) {
            $user->isMaintenance = $maintenances->contains($user->mail);

            return $user;
        });
    },
];
