import { http } from '@inside-library/helpers/Http'

export default {
  eventContents: {
    add: () => ({
      name: 'HomePage'
    }),
    delete: () => ({
      name: 'HomePage'
    })
  },
  spacesCategoriesPages: {
    fields: [{ spaces: ['slug'] }],
    add: ({ data }) => ({
      name: 'Space',
      params: { slug: data.spaces.data[0].slug[0] }
    }),
    delete: async ({ uuid }) => {
      const { data } = await http.get('content/spaces_categories_pages', {
        fields: [
          {
            spaces: {
              fields: ['slug'],
              filters: { 'status:eq': 1, limit: 1 }
            }
          }
        ],
        filters: { 'uuid:eq': uuid }
      })

      return { name: 'Space', params: { slug: data[0].spaces.data[0].slug[0] } }
    },
    globalSearch: () => ({
      routeAs: 'add'
    })
  },
  spacesPage: {
    fields: [
      'uuid',
      'status',
      { spaces_categories_pages: [{ spaces: ['slug'] }] }
    ],
    add: async ({ data }) => {
      const { data: category } = await http.get('content/spaces_page', {
        fields: [
          {
            spaces_categories_pages: {
              fields: [
                {
                  spaces: {
                    fields: ['slug'],
                    filters: { 'status:eq': 1, limit: 1 }
                  }
                }
              ],
              filters: { 'status:eq': 1, limit: 1 }
            }
          }
        ],
        filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
      })

      return {
        name: 'Space',
        params: {
          slug: category[0]?.spaces_categories_pages.data[0].spaces.data[0]
            .slug[0]
        },
        query: { page: data.uuid }
      }
    },
    delete: async ({ uuid }) => {
      const { data } = await http.get('content/spaces_page', {
        fields: [
          {
            spaces_categories_pages: {
              fields: [
                {
                  spaces: {
                    fields: ['slug'],
                    filters: { 'status:eq': 1, limit: 1 }
                  }
                }
              ],
              filters: { 'status:eq': 1, limit: 1 }
            }
          }
        ],
        filters: { 'status:eq': 1, 'uuid:eq': uuid }
      })

      return {
        name: 'Space',
        params: {
          slug: data[0].spaces_categories_pages.data[0].spaces.data[0].slug[0]
        }
      }
    },
    globalSearch: () => ({
      routeAs: 'add'
    })
  },
  spaces: {
    add: ({ data }) => ({
      name: 'Space',
      params: { slug: data.slug[0] }
    })
  }
}
