import { Link } from 'inside-collection/components'

export default {
  components: { Link },
  props: {
    slug: {
      type: Array,
      required: true
    },
    content_type: {
      type: String,
      default: 'news'
    }
  },
  data() {
    return {
      m_to: {
        name: this.content_type === 'forms' ? 'FormPage' : 'NewsPage',
        params: { slug: this.slug[0] }
      }
    }
  }
}
