import imageEventContent from '../../assets/img/custom-page/imageEventContent.png'
import imageFlashNews1Column from '@inside-library/assets/img/custom-page/imageFlashNews1Column.png'

export const availableComponents = t => [
  {
    component: 'EventContent',
    label: t('customs.CUSTOM_PAGE.eventContent.label'),
    image: imageEventContent,
    options: {},
    layouts: [
      { layout: 2 },
      { layout: 3 },
      { layout: 5 },
      { layout: 6 },
      { layout: 7 },
      { layout: 8 },
      { layout: 9 },
      { layout: 10 }
    ]
  },
  {
    component: 'FlashNews',
    label: t('customs.CUSTOM_PAGE.flashNews.label'),
    image: imageFlashNews1Column,
    options: {},
    layouts: [
      { layout: 1 },
      { layout: 2 },
      { layout: 3 },
      { layout: 5, requiredRatio: 3 },
      { layout: 6, requiredRatio: 3 },
      { layout: 7 },
      { layout: 8 },
      { layout: 9, requiredRatio: 2 },
      { layout: 10, requiredRatio: 2 }
    ]
  }
]

export const componentImport = {
  EventContent: () => import('../../components/homepage/HomepageEventContent'),
  FlashNews: () => import('../../components/homepage/HomepageFlashNews')
}
