<?php

namespace Inside\EPAR\Providers;

use Inside\Providers\ServiceProvider as BaseServiceProvider;
use Illuminate\Support\Facades\Event;

/**
 * EPAR Service provider.
 *
 * @category Class
 * @package  Inside\EPAR\Providers\ServiceProvider
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ServiceProvider extends BaseServiceProvider
{
    /**
     * @var array
     */
    protected $listen = [

    ];

    /**
     * Boot
     */
    public function boot(): void
    {
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');

        foreach ($this->listen as $event => $listeners) {
            foreach ($listeners as $listener) {
                Event::listen($event, $listener);
            }
        }
    }

    /**
     * Register
     */
    public function register(): void
    {
        $this->mergeRecursiveConfigFrom(
            __DIR__ . '/../../config/scheduler.php',
            'scheduler'
        );

        $this->mergeConfigFrom(__DIR__ . '/../../config/csv.php', 'csv');
        $this->mergeConfigTo(__DIR__. '/../../config/archive.php', 'archive');
        $this->mergeConfigTo(__DIR__ . '/../../config/notify.php', 'notify');
        $this->mergeConfigTo(__DIR__ . '/../../config/statistics.php', 'statistics');
    }
}
