<?php

namespace Inside\EPAR\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Contents\News;
use Inside\Reaction\Facades\Reactions;
use Laravel\Lumen\Routing\Controller;

class PopinController extends Controller
{
    public function popin(Request $request): array
    {
        $news = News::query()->where('status', 1)->where('info_flash', 1)->orderBy('created_at', 'DESC')->first();

        if (empty($news)) {
            return [
                'popin' => false
            ];
        }

        /** @var User $user */
        $user = Auth::user();
        $reaction = DB::table('inside_reactions')
            ->where('type', 'infoflash')
            ->where('user_uuid', $user->uuid)
            ->where('reactionable_uuid', $news->uuid)
            ->where('created_at', 'LIKE', date('Y-m-d', time()) . ' %')
            ->orderBy('created_at', 'DESC')->get();

        $count = $reaction->count();

        return [
            'popin' => !(bool)$count,
            'reaction_date' => $count === 0 ? null : $reaction->pluck('created_at')->first()
        ];
    }

    /**
     * @param Request $request
     * @return mixed
     */
    public function reaction(Request $request)
    {
        /** @var User $user */
        $user = Auth::user();
        $user = $user->uuid;
        $uuid = $request->input('uuid');

        $reactions = DB::table('inside_reactions')
            ->where('type', 'infoflash')
            ->where('user_uuid', $user)
            ->orderBy('created_at', 'DESC')->get();

        $data = News::findOrFail($uuid);
        if ($reactions->count()) {
            foreach ($reactions as $reaction) {
                Reactions::delete('infoflash', $reaction->reactionable_uuid, $reaction->user_uuid, $reaction->langcode);
            }
        }

        $create = Reactions::create([
            'user_uuid' => $user,
            'reactionable_uuid' => $uuid,
            'reactionable_type' => News::class,
            'type' => 'infoflash',
            'langcode' => $data->langcode
        ]);
        return $create;
    }
}
