<?php

use Inside\Host\Bridge\BridgeContentType;
use Illuminate\Database\Migrations\Migration;

class UpdateSpacesInSpacesCategoriesPages extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();
        $bridge->contentTypeCreateOrUpdateField(
            type: 'spaces_categories_pages',
            fieldName: 'spaces',
            options: [
                'name' => 'spaces',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => true,
                'weight' => -5,
                'title' => [
                    'fr' => 'Espace'
                ],
                'description' => [],
                'widget' => [
                    'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                    'settings' => [],
                    'weight' => -5,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['spaces'],
                    'cardinality' => -1,
                ],
            ],
            weight: -4
        );
    }
}
