<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Tools;
use Inside\Host\Bridge\BridgeContent;

final class UpdateShowOnMobileOfToolsContents extends Migration
{
    public function up(): void
    {
        $bridgeContent = new BridgeContent();

        Tools::pluck('uuid')->each(fn (string $uuid) => $bridgeContent->contentUpdate('tools', ['uuid' => $uuid, 'show_on_mobile' => true]));
    }
}
