<?php

use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Models\Contents\InfoBanner;
use Illuminate\Database\Migrations\Migration;

class UpdateInfoBanner extends Migration
{
    public function up(): void
    {
        $bridgeContentType = new BridgeContentType();
        $bridgeContentType->contentTypeCreateOrUpdateField('info_banner', 'flash_content', [
            'name' => 'flash_content',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'search_filter' => false,
            'required' => true,
            'weight' => 1,
            'title' => [
                'fr' => 'Contenu',
            ],
            'widget' => [
                'type' => BridgeContentType::WYSIWYG_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::WYSIWYG_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ]);
        $bridgeContentType->contentTypeCreateOrUpdateField('info_banner', 'end_date', [
            'name' => 'end_date',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'search_filter' => false,
            'required' => true,
            'weight' => 2,
            'title' => [
                'fr' => 'Date de fin',
            ],
            'description' => [
                'fr' => 'Choix de la date et heure de dépublication du flash info',
            ],
            'widget' => [
                'type' => BridgeContentType::TIMESTAMP_WIDGET,
                'settings' => [],
                'weight' => 2,
            ],
            'type' => BridgeContentType::TIMESTAMP_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ]);
        $bridgeContentType->contentTypeCreateOrUpdateField('info_banner', 'dark_mode', [
            'name' => 'dark_mode',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'search_filter' => false,
            'required' => false,
            'weight' => 12,
            'title' => [
                'fr' => 'Passer le titre et l\'icône en blanc',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 12,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => true,
        ]);
        $bridgeContentType->contentTypeCreateOrUpdateField('info_banner', 'background_color', [
            'name' => 'background_color',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'search_filter' => false,
            'required' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Couleur de fond',
            ],
            'widget' => [
                'type' => BridgeContentType::INSIDE_COLOR_PICKER_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ]);

        $bridge = new BridgeContent();
        foreach (InfoBanner::get() as $infoBanner) {
            $infoText = $infoBanner->textSectionItem[0]->body;
            $bridge->contentUpdate('info_banner', [
                'uuid' => $infoBanner->uuid,
                'flash_content' => $infoText,
                'end_date'  => strtotime('2023-10-30')
            ]);
        }

        $bridgeContentType->contentTypeDeleteField('node', 'info_banner', 'content');
    }
}
