<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Migrations\CreateContentTypes;

final class CreateBlocksContentType extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('blocks');
        $this->transformEventContentsToBlocks();
        $this->getBridge()?->contentTypeDelete('event_contents');
        $this->finishUp();
    }

    private function transformEventContentsToBlocks(): void
    {
        Artisan::call('models:rebuild');

        if (! class_exists(type_to_class('blocks')) || ! class_exists(type_to_class('event_contents'))) {
            throw new Exception('Missing blocks or event_contents class');
        }

        $bridgeContent = new BridgeContent();
        type_to_class('event_contents')::all()
            ->each(function ($eventContent) use ($bridgeContent) {
                $bridgeContent->contentInsert('blocks', [
                    'title' => $eventContent->title,
                    'icon' => $eventContent->icon,
                    'link' => $eventContent->link,
                    'link_label' => $eventContent->link_text,
                ]);
            });
    }
}
