<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class FixSolrFilters extends Migration
{
    public function up(): void
    {
        $types = [
            'news' => 'news_categories',
            'events' => 'events_categories',
            'tools' => 'tools_categories'
        ];

        $bridge = new BridgeContentType();

        foreach ($types as $type => $field) {
            $bridge->updateFieldOptions($type, $field, [
                'searchable_filter' => true
            ]);
        }
    }

    public function down(): void
    {
    }
}
