<?php


use Inside\Host\Bridge\BridgeContentType;

$weight = 1;

return [
    'options' => [
        'translatable' => false,
        'searchable' => true,
        'global_searchable' => true,
        'aliasable' => true,
        'permissible' => true,
        'categorizable' => false,
        'listing_type' => 'content',
        'name' => 'spaces',
        'title' => [
            'fr' => 'Espace'
        ],
    ],
    'fields' => [
        [
            'name'                  => 'banner',
            'searchable'            => false,
            'translatable'          => false,
            'default'               => null,
            'search_result_field'   => false,
            'required'              => false,
            'weight'                => $weight,
            'title'                 => [
                'fr' => 'Bannière',
            ],
            'description'           => [
                'fr' => '',
            ],
            'widget'                => [
                'type'      => BridgeContentType::IMAGE_WIDGET,
                'settings'  => [
                    'progress_indicator'  => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight'    => $weight++,
                'group'     => 'group_advanced_options',
            ],
            'type'                  => BridgeContentType::IMAGE_FIELD,
            'settings'              => [
                'uri_scheme'      => 'public',
                'default_image'   => [
                    'uuid'    => '',
                    'alt'     => '',
                    'title'   => '',
                    'width'   => null,
                    'height'  => null,
                ],
                'target_type'     => 'file',
                'display_field'   => false,
                'display_default' => false,
                'cardinality'     => 1,
            ],
        ],
        [
            'name' => 'introduction',
            'searchable' => false,
            'translatable' => false,
            'default' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => $weight,
            'title' => [
                'fr' => 'Introduction',
            ],
            'description' => [
                'fr' => '',
            ],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows' => 5,
                    'placeholder' => '',
                ],
                'weight' => $weight++,
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
    ]
];
